/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    static PrinterData[] printerList;
    static int findPrinter;
    static PrinterData findData;
    PrinterData data;
    int printer;
    int printJob;
    int settings;
    int pageSetup;
    int surface;
    int cairo;
    boolean isGCCreated = false;
    static byte[] settingsData;
    static int start;
    static int end;
    static final String GTK_LPR_BACKEND = "GtkPrintBackendLpr";
    static final String GTK_FILE_BACKEND = "GtkPrintBackendFile";
    static boolean disablePrinting;

    static void gtk_init() {
        if (OS.GLIB_VERSION < OS.VERSION(2, 32, 0) && !OS.g_thread_supported()) {
            OS.g_thread_init(0);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 24, 0)) {
            OS.gtk_set_locale();
        }
        if (!OS.gtk_init_check(new int[]{0}, null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
    }

    public static PrinterData[] getPrinterList() {
        printerList = new PrinterData[0];
        if (disablePrinting) {
            return printerList;
        }
        Printer.gtk_init();
        Callback callback = new Callback(Printer.class, "GtkPrinterFunc_List", 2);
        int n = callback.getAddress();
        if (n == 0) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(n, 0, 0, true);
        OS.gdk_threads_leave();
        callback.dispose();
        return printerList;
    }

    static int GtkPrinterFunc_List(int n, int n2) {
        int n3 = printerList.length;
        PrinterData[] printerDataArray = new PrinterData[n3 + 1];
        System.arraycopy(printerList, 0, printerDataArray, 0, n3);
        printerList = printerDataArray;
        Printer.printerList[n3] = Printer.printerDataFromGtkPrinter(n);
        if (Printer.printerList[n3].driver.equals(GTK_LPR_BACKEND)) {
            return 1;
        }
        return 0;
    }

    public static PrinterData getDefaultPrinterData() {
        findData = null;
        if (disablePrinting) {
            return null;
        }
        Printer.gtk_init();
        Callback callback = new Callback(Printer.class, "GtkPrinterFunc_Default", 2);
        int n = callback.getAddress();
        if (n == 0) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(n, 0, 0, true);
        OS.gdk_threads_leave();
        callback.dispose();
        return findData;
    }

    static int GtkPrinterFunc_Default(int n, int n2) {
        if (OS.gtk_printer_is_default(n)) {
            findData = Printer.printerDataFromGtkPrinter(n);
            return 1;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 12) && Printer.printerDataFromGtkPrinter((int)n).driver.equals(GTK_LPR_BACKEND)) {
            return 1;
        }
        return 0;
    }

    static int gtkPrinterFromPrinterData(PrinterData printerData) {
        Printer.gtk_init();
        Callback callback = new Callback(Printer.class, "GtkPrinterFunc_FindNamedPrinter", 2);
        int n = callback.getAddress();
        if (n == 0) {
            SWT.error(3);
        }
        findPrinter = 0;
        findData = printerData;
        OS.gtk_enumerate_printers(n, 0, 0, true);
        OS.gdk_threads_leave();
        callback.dispose();
        return findPrinter;
    }

    static int GtkPrinterFunc_FindNamedPrinter(int n, int n2) {
        PrinterData printerData = Printer.printerDataFromGtkPrinter(n);
        if (printerData.driver.equals(Printer.findData.driver) && printerData.name.equals(Printer.findData.name) || printerData.driver.equals(GTK_FILE_BACKEND) && Printer.findData.printToFile && Printer.findData.driver == null && Printer.findData.name == null) {
            findPrinter = n;
            OS.g_object_ref(n);
            return 1;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 12) && printerData.driver.equals(GTK_LPR_BACKEND)) {
            return 1;
        }
        return 0;
    }

    static PrinterData printerDataFromGtkPrinter(int n) {
        int n2 = OS.gtk_printer_get_backend(n);
        int n3 = OS.G_OBJECT_TYPE_NAME(n2);
        int n4 = OS.strlen(n3);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n3, n4);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        n3 = OS.gtk_printer_get_name(n);
        n4 = OS.strlen(n3);
        byArray = new byte[n4];
        OS.memmove(byArray, n3, n4);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        return new PrinterData(string, string2);
    }

    static void restore(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        byte[] byArray3;
        settingsData = byArray;
        end = 0;
        start = 0;
        while (end < settingsData.length && settingsData[end] != 0) {
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byArray3 = new byte[++end - start];
            System.arraycopy(settingsData, start, byArray3, 0, byArray3.length);
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byArray2 = new byte[++end - start];
            System.arraycopy(settingsData, start, byArray2, 0, byArray2.length);
            OS.gtk_print_settings_set(n, byArray3, byArray2);
            if (!DEBUG) continue;
            System.out.println(new String(Converter.mbcsToWcs(null, byArray3)) + ": " + new String(Converter.mbcsToWcs(null, byArray2)));
        }
        ++end;
        OS.gtk_page_setup_set_orientation(n2, Printer.restoreInt("orientation"));
        OS.gtk_page_setup_set_top_margin(n2, Printer.restoreDouble("top_margin"), 3);
        OS.gtk_page_setup_set_bottom_margin(n2, Printer.restoreDouble("bottom_margin"), 3);
        OS.gtk_page_setup_set_left_margin(n2, Printer.restoreDouble("left_margin"), 3);
        OS.gtk_page_setup_set_right_margin(n2, Printer.restoreDouble("right_margin"), 3);
        byArray3 = Printer.restoreBytes("paper_size_name", true);
        byArray2 = Printer.restoreBytes("paper_size_display_name", true);
        byte[] byArray4 = Printer.restoreBytes("paper_size_ppd_name", true);
        double d = Printer.restoreDouble("paper_size_width");
        double d2 = Printer.restoreDouble("paper_size_height");
        boolean bl = Printer.restoreBoolean("paper_size_is_custom");
        int n3 = 0;
        n3 = bl ? (byArray4.length > 0 ? OS.gtk_paper_size_new_from_ppd(byArray4, byArray2, d, d2) : OS.gtk_paper_size_new_custom(byArray3, byArray2, d, d2, 3)) : OS.gtk_paper_size_new(byArray3);
        OS.gtk_page_setup_set_paper_size(n2, n3);
        OS.gtk_paper_size_free(n3);
    }

    static byte[] uriFromFilename(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return null;
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int[] nArray = new int[1];
        int n2 = OS.g_utf16_to_utf8(cArray, cArray.length, null, null, nArray);
        if (nArray[0] != 0 || n2 == 0) {
            return null;
        }
        int n3 = OS.g_filename_from_utf8(n2, -1, null, null, nArray);
        OS.g_free(n2);
        if (nArray[0] != 0 || n3 == 0) {
            return null;
        }
        int n4 = OS.g_filename_to_uri(n3, 0, nArray);
        OS.g_free(n3);
        if (nArray[0] != 0 || n4 == 0) {
            return null;
        }
        n = OS.strlen(n4);
        byte[] byArray = new byte[n + 1];
        OS.memmove(byArray, n4, n);
        OS.g_free(n4);
        return byArray;
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            int n;
            PrinterData printerData2 = null;
            if (printerData.printToFile && (n = Printer.gtkPrinterFromPrinterData(printerData)) != 0) {
                printerData2 = Printer.printerDataFromGtkPrinter(n);
                OS.g_object_unref(n);
            }
            if (printerData2 == null && (printerData2 = Printer.getDefaultPrinterData()) == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    static int restoreInt(String string) {
        byte[] byArray = Printer.restoreBytes(string, false);
        return Integer.parseInt(new String(byArray));
    }

    static double restoreDouble(String string) {
        byte[] byArray = Printer.restoreBytes(string, false);
        return Double.parseDouble(new String(byArray));
    }

    static boolean restoreBoolean(String string) {
        byte[] byArray = Printer.restoreBytes(string, false);
        return Boolean.valueOf(new String(byArray));
    }

    static byte[] restoreBytes(String string, boolean bl) {
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        byte[] byArray = new byte[++end - start];
        System.arraycopy(settingsData, start, byArray, 0, byArray.length);
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        int n = end - start;
        ++end;
        if (bl) {
            ++n;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(settingsData, start, byArray2, 0, n);
        if (DEBUG) {
            System.out.println(new String(Converter.mbcsToWcs(null, byArray)) + ": " + new String(Converter.mbcsToWcs(null, byArray2)));
        }
        return byArray2;
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        int n2 = 0;
        if (OS.USE_CAIRO) {
            n = this.cairo;
        } else {
            GdkVisual gdkVisual = new GdkVisual();
            OS.memmove(gdkVisual, OS.gdk_visual_get_system());
            n2 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), 1, 1, gdkVisual.depth);
            n = OS.gdk_gc_new(n2);
        }
        if (n == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n3;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((gCData.style & (n3 = 0x6000000)) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.drawable = n2;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            gCData.width = (int)(OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)point.x / (double)point2.x);
            gCData.height = (int)(OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)point.y / (double)point2.y);
            if (this.cairo == 0) {
                SWT.error(2);
            }
            Cairo.cairo_identity_matrix(this.cairo);
            double d = OS.gtk_page_setup_get_left_margin(this.pageSetup, 1);
            double d2 = OS.gtk_page_setup_get_top_margin(this.pageSetup, 1);
            Cairo.cairo_translate(this.cairo, d, d2);
            Cairo.cairo_scale(this.cairo, (float)point2.x / (float)point.x, (float)point2.y / (float)point.y);
            double[] dArray = new double[6];
            Cairo.cairo_get_matrix(this.cairo, dArray);
            gCData.identity = dArray;
            gCData.cairo = this.cairo;
            this.isGCCreated = true;
        }
        return n;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        int n2 = n;
        if (gCData != null) {
            this.isGCCreated = false;
        }
        if (OS.USE_CAIRO) {
            return;
        }
        OS.g_object_unref(n2);
        if (gCData != null) {
            if (gCData.drawable != 0) {
                OS.g_object_unref(gCData.drawable);
            }
            gCData.cairo = 0;
            gCData.drawable = 0;
        }
    }

    public boolean startJob(String string) {
        this.checkDevice();
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        this.printJob = OS.gtk_print_job_new(byArray, this.printer, this.settings, this.pageSetup);
        if (this.printJob == 0) {
            return false;
        }
        this.surface = OS.gtk_print_job_get_surface(this.printJob, null);
        if (this.surface == 0) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0;
            return false;
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0;
            return false;
        }
        return true;
    }

    protected void destroy() {
        if (this.printer != 0) {
            OS.g_object_unref(this.printer);
        }
        if (this.settings != 0) {
            OS.g_object_unref(this.settings);
        }
        if (this.pageSetup != 0) {
            OS.g_object_unref(this.pageSetup);
        }
        if (this.cairo != 0) {
            Cairo.cairo_destroy(this.cairo);
        }
        if (this.printJob != 0) {
            OS.g_object_unref(this.printJob);
        }
        this.printJob = 0;
        this.cairo = 0;
        this.pageSetup = 0;
        this.settings = 0;
        this.printer = 0;
    }

    public void endJob() {
        this.checkDevice();
        if (this.printJob == 0) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.gtk_print_job_send(this.printJob, 0, 0, 0);
        OS.g_object_unref(this.printJob);
        this.printJob = 0;
    }

    public void cancelJob() {
        this.checkDevice();
        if (this.printJob == 0) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.g_object_unref(this.printJob);
        this.printJob = 0;
    }

    public boolean startPage() {
        this.checkDevice();
        if (this.printJob == 0) {
            return false;
        }
        double d = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1);
        double d2 = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1);
        int n = Cairo.cairo_surface_get_type(this.surface);
        switch (n) {
            case 2: {
                Cairo.cairo_ps_surface_set_size(this.surface, d, d2);
                break;
            }
            case 1: {
                Cairo.cairo_pdf_surface_set_size(this.surface, d, d2);
            }
        }
        return true;
    }

    public void endPage() {
        this.checkDevice();
        if (this.cairo != 0) {
            Cairo.cairo_show_page(this.cairo);
        }
    }

    public Point getDPI() {
        this.checkDevice();
        int n = OS.gtk_print_settings_get_resolution(this.settings);
        if (DEBUG) {
            System.out.println("print_settings.resolution=" + n);
        }
        if (n == 0) {
            return new Point(72, 72);
        }
        return new Point(n, n);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        double d = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d2 = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        return new Rectangle(0, 0, (int)d, (int)d2);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        double d = OS.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d2 = OS.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        return new Rectangle(0, 0, (int)d, (int)d2);
    }

    Point getIndependentDPI() {
        return new Point(72, 72);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkDevice();
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        double d = OS.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d2 = OS.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        double d3 = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d4 = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        double d5 = -OS.gtk_page_setup_get_left_margin(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d6 = -OS.gtk_page_setup_get_top_margin(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        double d7 = d3 - d;
        double d8 = d4 - d2;
        return new Rectangle(n + (int)d5, n2 + (int)d6, n3 + (int)d7, n4 + (int)d8);
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        if (disablePrinting) {
            SWT.error(2);
        }
        this.printer = Printer.gtkPrinterFromPrinterData(this.data);
        if (this.printer == 0) {
            SWT.error(2);
        }
    }

    protected void init() {
        byte[] byArray;
        this.settings = OS.gtk_print_settings_new();
        this.pageSetup = OS.gtk_page_setup_new();
        if (this.data.otherData != null) {
            Printer.restore(this.data.otherData, this.settings, this.pageSetup);
        }
        if (this.data.printToFile && this.data.fileName != null && (byArray = Printer.uriFromFilename(this.data.fileName)) != null) {
            OS.gtk_print_settings_set(this.settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, byArray);
        }
        OS.gtk_print_settings_set_n_copies(this.settings, this.data.copyCount);
        OS.gtk_print_settings_set_collate(this.settings, this.data.collate);
        if (this.data.duplex != -1) {
            int n = this.data.duplex == 1 ? 1 : (this.data.duplex == 2 ? 2 : 0);
            OS.gtk_print_settings_set_duplex(this.settings, n);
            String string = null;
            if (n == 1) {
                string = "DuplexNoTumble";
            } else if (n == 2) {
                string = "DuplexTumble";
            }
            if (string != null) {
                byte[] byArray2 = Converter.wcsToMbcs(null, "cups-Duplex", true);
                byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
                OS.gtk_print_settings_set(this.settings, byArray2, byArray3);
            }
        }
        int n = this.data.orientation == 2 ? 1 : 0;
        OS.gtk_page_setup_set_orientation(this.pageSetup, n);
        OS.gtk_print_settings_set_orientation(this.settings, n);
        super.init();
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }

    static {
        disablePrinting = System.getProperty("org.eclipse.swt.internal.gtk.disablePrinting") != null;
    }
}

